import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;

// Press Shift twice to open the Search Everywhere dialog and type `show whitespaces`,
// then press Enter. You can now see whitespace characters in your code.
public class Main {
    public static final String SERVIDOR = "SERVIDOR: ";

    public static void main(String[] args) {

        try {
            Socket skCliente;
            System.out.println("Creando el server socket");

            //ServerSocket, es crear un servicio, con un puerto determinado.
            ServerSocket skServidor = new ServerSocket(5000);

            while (true) {

                System.out.println("Esperando al cliente");

                skCliente = skServidor.accept(); //Bloqueante (Flujo detenido) hasta que haya una petición
                System.out.println("Atendiendo al cliente");

                //Bloque [Entrada de datos]
                InputStream aux = skCliente.getInputStream(); //Corazón
                DataInputStream flujo_entrada = new DataInputStream(aux); //Mente
                //Fin Bloque

                //Bloque [Salida de datos]
                OutputStream aux2 = skCliente.getOutputStream();
                DataOutputStream flujo_salida = new DataOutputStream(aux2);
                //Fin Bloque.



                flujo_salida.writeUTF(SERVIDOR + "Cliente conectado correctamente.");

                //Se solicita ID único
                String idClienteUnico = flujo_entrada.readUTF();


                int opcion = 0;

                while (opcion != 4) {

                    flujo_salida.writeUTF(SERVIDOR + "Introduzca la opción a elegir\n" +
                            "1. Suma.\n" +
                            "2. Raiz Cuadrada.\n" +
                            "3. Series\n" +
                            "4. Salir del programa.");
                    opcion = flujo_entrada.readInt();

                    if (opcion>0 && opcion<5){


                        String[] opciones = {"Suma", "Raíz Cuadrada", "Series","Cerrrar Conexión"};
                        System.out.println("CLIENTE-" +idClienteUnico+" : " + "Solicita la " + opciones[opcion - 1] + " (" + opcion + ")");
                        flujo_salida.writeUTF(SERVIDOR + "Cliente " + "Solicita la " + opciones[opcion - 1] + " (" + opcion + ")");
                    }

                        switch (opcion) {
                            case 1:
                                //Se piden 2 operandos.
                                flujo_salida.writeInt(2);
                                int operando1 = flujo_entrada.readInt();
                                int operando2 = flujo_entrada.readInt();
                                int suma = operando1 + operando2;
                                flujo_salida.writeUTF(SERVIDOR + "La suma total es: " + suma);
                                System.out.println(SERVIDOR + "La suma total es: " + suma);
                                break;
                            case 2:
                                flujo_salida.writeInt(1);
                                int operando = flujo_entrada.readInt();
                                flujo_salida.writeUTF(SERVIDOR + "La raiz cuadrada de " + operando + " es: " + Math.sqrt(operando));
                                System.out.println(SERVIDOR + "La raiz cuadrada de " + operando + " es: " + Math.sqrt(operando));
                                break;
                            case 3:
                                flujo_salida.writeInt(0); //Puesto que no lo decide el servidor, le doy un número no válido.
                                flujo_salida.writeUTF(SERVIDOR + "Introduzca el número de operandos.");
                                int numOperandos = flujo_entrada.readInt();
                                int[] serie = new int[numOperandos];
                                for (int i = 0; i < numOperandos; i++) {
                                    serie[i] = flujo_entrada.readInt();
                                }

                                //¿Cuál es el último número, con el que se pretende continuar?
                                int ultimoNumero = serie[numOperandos - 1];

                                //¿Cual es el término que define la sucesión?
                                int terminoSucesion = serie[numOperandos - 1] - serie[numOperandos - 2];

                                //Mensaje final.
                                flujo_salida.writeUTF(SERVIDOR + "El número que continúa es: " + (ultimoNumero + terminoSucesion));
                                System.out.println(SERVIDOR + "El número que continúa es: " + (ultimoNumero + terminoSucesion));
                                break;


                            case 4:
                                System.out.println("Operación desconexión solicitada");
                                int port = skCliente.getLocalPort();
                                System.out.println("SERVIDOR: Desconecto el socket del cliente del puerto " + port);
                                flujo_salida.writeUTF("SERVIDOR: Desconecto el socket del cliente del puerto " + port);

                                skCliente.close();
                                break;
                            default:
                                flujo_salida.writeUTF("SERVIDOR: Desconoce la operación, DESCONECTA.");
                                skCliente.close();

                                System.out.println("Operación no reconocida");
                        }
                    }
            }


        } catch (IOException e) {
            System.out.println(e.getMessage());
        }


    }
}